<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xslt [
  <!ENTITY TNSPREFIX "'acme:'">
]>
<xsl:stylesheet 
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsd="http://www.w3.org/2000/10/XMLSchema"
	xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
	xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
	xmlns:http="http://schemas.xmlsoap.org/wsdl/http/"
	xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/">

<!--Query parameters -->
<xsl:param name="service" select="'ALL'"/>
<xsl:param name="port" select="'ALL'"/>
<xsl:param name="binding" select="'ALL'"/>
<xsl:param name="portType" select="'ALL'"/>

<!-- A technique (or a hack) to make variables empty   -->
<!-- if the corrsponding parameter is ALL or otherwise -->
<!-- the concatenation of &TNSPREFIX and the paramter  -->
<!-- For example, number($service = 'ALL') * 99999 + 1 -->
<!-- will be 1 if $service is not equal to 'ALL' but   -->
<!-- 100000 if it is and hence beyond the lenght of the--> 
<!-- string which causes substring to return empty     -->
<!-- This is all to simplify cross-referencing.        -->
<xsl:variable name="serviceRef" 
              select="substring(concat(&TNSPREFIX;,$service),
                                number($service = 'ALL') * 99999 + 1)"/>
<xsl:variable name="portRef"
              select="substring(concat(&TNSPREFIX;,$port),
                                number($port = 'ALL') * 99999 + 1)"/>
<xsl:variable name="bindingRef"
              select="substring(concat(&TNSPREFIX;,$binding),
                                number($binding = 'ALL') * 99999 + 1)"/>
<xsl:variable name="portTypeRef"
              select="substring(concat(&TNSPREFIX;,$portType),
                                number($portType = 'ALL') * 99999 + 1)"/>

<!-- These keys simplify and speed up querying -->              
<xsl:key name="bindings_key" 
         match="wsdl:binding" use="concat(&TNSPREFIX;,@name)"/>
<xsl:key name="portType_key"
         match="wsdl:portType" use="concat(&TNSPREFIX;,@name)"/>

<xsl:output method="html"/>

  <xsl:template match="/">
      <html>
      <head>
        <title>ACME Web Services, Inc. Query Result</title>
        <xsl:comment>WSDL Documentation: Generated by wsdlServiceList.xslt</xsl:comment>
      </head>
      <body>
        <xsl:apply-templates select="wsdl:definitions"/> 
      </body>
    </html>
</xsl:template>

<xsl:template match="wsdl:definitions">
   <xsl:variable name="result">
        <!-- Query services that match the query parameters             -->
        <!-- The portType match is the only complicated part            -->
        <!-- We need to traverse form the services port, to the binding -->
        <!-- and then to the binding's type to do the match. Hence      -->
        <!-- the nested key() calls                                     -->
        <xsl:apply-templates 
             select="wsdl:service[
                    (not($serviceRef)  or @name = $service) and
                    (not($portRef)     or wsdl:port/@name = $port) and
                    (not($bindingRef)  or wsdl:port/@binding = $bindingRef) and
                    (not($portTypeRef) or key('portType_key',
                                               key('bindings_key',
                                                    wsdl:port/@binding)/@type)
                                                        /@name = $portType)]"/>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="normalize-space($result)">
      <xsl:copy-of select="$result"/>
    </xsl:when>
    <xsl:otherwise>
      <p><b>No Matching Services Found</b></p>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="wsdl:service">
     <xsl:apply-templates select="." mode="display">
     </xsl:apply-templates>
</xsl:template>

<xsl:template match="wsdl:service" mode="display">
<h1><xsl:value-of select="@name"/></h1>
<p><xsl:value-of select="wsdl:documentation"/></p>
<table border="1" cellpadding="5" cellspacing="0"  width="600">
  <tbody>
    <xsl:apply-templates 
         select="wsdl:port[(not($portRef) or @name = $port) and
                           (not($bindingRef) or @binding = $bindingRef)]" 
         mode="display"/>
  </tbody>
</table>
</xsl:template>

<xsl:template match="wsdl:port" mode="display">
    <tr>
      <td style="font-weight:bold" colspan="2" align="center">Port</td>
    </tr>
    <tr>
      <td colspan="2"><h3><xsl:value-of select="@name"/></h3></td>
    </tr>
    <tr>
      <td style="font-weight:bold" width="50">Binding</td>
      <td><xsl:value-of select="substring-after(@binding,':')"/></td>
    </tr>
    <tr>
      <td style="font-weight:bold" width="50">Address</td>
      <td><xsl:value-of select="soap:address/@location"/></td>
    </tr>
    <tr>
      <th colspan="2" align="center">Operations</th>
    </tr>
    <xsl:apply-templates select="key('bindings_key',@binding)" mode="display"/>
</xsl:template>

<xsl:template match="wsdl:binding" mode="display">
  <xsl:apply-templates select="key('portType_key',@type)" mode="display">
    <xsl:with-param name="operation" select="wsdl:operation/@name"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="wsdl:portType" mode="display">
  <xsl:param name="operation"/>
  <xsl:for-each select="wsdl:operation[@name = $operation]">
    <tr>
      <td colspan="2"><h3><xsl:value-of select="@name"/></h3></td>
    </tr>
    <xsl:if test="wsdl:input">
      <tr>
        <td style="font-weight:bold" width="50">Input</td>
        <td><xsl:value-of select="substring-after(wsdl:input/@message,':')"/></td>
      </tr>
      <xsl:variable name="msgName" select="substring-after(wsdl:input/@message,':')"/>
      <xsl:apply-templates select="/*/wsdl:message[@name = $msgName]" mode="display"/>
    </xsl:if>
    <xsl:if test="wsdl:output">
      <tr>
        <td style="font-weight:bold" width="50">Output</td>
        <td><xsl:value-of select="substring-after(wsdl:output/@message,':')"/></td>
      </tr>
      <xsl:variable name="msgName" select="substring-after(wsdl:output/@message,':')"/>
      <xsl:apply-templates select="/*/wsdl:message[@name = $msgName]" mode="display"/>
   </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="wsdl:message" mode="display">
  <xsl:variable name="dataType" select="substring-after(wsdl:part[@name='body']/@element,':')"/>
  <tr>
    <td colspan="2">
      <xsl:apply-templates  select="/*/wsdl:types/*/*[@name=$dataType]" mode="display">
        <xsl:with-param name="initial-newline" select="false()"/>
      </xsl:apply-templates>
    </td>
  </tr>
</xsl:template>

<!-- This code is used to render the xsd schema of messages as xml within html-->

<xsl:template match="*" mode="display">
  <xsl:param name="initial-newline" select="true()"/>
  
  <xsl:if test="$initial-newline">
    <xsl:call-template name="newline"/>
  </xsl:if>
  <!-- open tag -->
  <a style="color:blue">&lt;</a>
  <a style="color:darkred"><xsl:value-of select="name(.)" /> </a>
  
  <!-- Output attributes -->
  <xsl:for-each select="@*">
    <a style="color:red"><xsl:text> </xsl:text><xsl:value-of select="name(.)" /> </a>
    <a style="color:blue">=&quot;</a>
    <xsl:value-of select="." />
    <a style="color:blue">&quot;</a>
  </xsl:for-each>
  
  <xsl:choose>
  	<xsl:when test="child::node()">
        <!-- close start tag -->
        <a style="color:blue">&gt;</a>
        <xsl:apply-templates  mode="display"/>
        <xsl:call-template name="newline"/>
        <!-- closing tag -->
        <a style="color:blue">&lt;</a>
        <a style="color:darkred">/<xsl:value-of select="name(.)" /></a>
  	</xsl:when>
  	<xsl:otherwise>
  		<a style="color:blue">/</a>
  	</xsl:otherwise>
  </xsl:choose>
  <a style="color:blue">&gt;</a>
</xsl:template>

<!-- Add a newline and then indent based on depth within the schema -->
<xsl:template name="newline">
	<br/>
	<xsl:for-each select="ancestor::xsd:*[not(self::xsd:schema)]">
		<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
